/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.MemoryUsageTable;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.ParameterItemTable;
import DE.siemens.ad.logo.model.ParameterItemValueComparator;
import DE.siemens.ad.logo.model.ParameterItemValueFormatter;
import DE.siemens.ad.logo.model.ParameterUpdateEvent;
import DE.siemens.ad.logo.model.ParameterUpdateListener;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.model.Remanence;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.Visitable;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.visitor.build.Visitor;
import DE.siemens.ad.logo.util.CodeBlock;
import DE.siemens.ad.logo.util.DifferenceTableModel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.logo.util.Logger.LocalizedInfo;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.logo.util.ValueOrItemReference;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public abstract class BlockParameter
extends Parameter
implements Visitable,
LocalizedInfo {
    protected transient String fCurrentParameterText;
    protected transient boolean fLastBinaryValue;
    static final long serialVersionUID = 136171616738026713L;
    private int blockParameterSerializedDataVersion = 1;
    protected Block fBlock;
    protected int fData;
    protected int fAllocatedTimer;
    protected int fParameter;
    protected Remanence fRemanence = null;
    protected transient Vector fParameterUpdateListeners;
    protected transient ParameterUpdateEvent fParameterUpdateEvent;
    protected transient Interpreter fInterpreter;

    public int getNeededREMOrRAM() {
        Hardware hardware;
        MemoryUsageTable blockREMMemoryUsageTable;
        int ramOrRem = this.fData;
        Block block = this.getBlock();
        WiringDiagram wiringDiagram = block.getWiringDiagram();
        if (wiringDiagram != null && (blockREMMemoryUsageTable = (MemoryUsageTable)(hardware = wiringDiagram.getHardware()).getProperty("blockREMMemoryTable")) != null) {
            ramOrRem = blockREMMemoryUsageTable.getMemoryUsage(block);
        }
        return ramOrRem;
    }

    public BlockParameter() {
    }

    public BlockParameter(Block block) {
        this.fBlock = block;
        this.fData = 0;
        this.fAllocatedTimer = 0;
        this.fParameter = 0;
    }

    public Object acceptVisitor(Visitor visitor) {
        CodeBlock c = new CodeBlock(visitor, "visit");
        c.addParameter(this);
        Object returnValue = null;
        try {
            returnValue = c.execMethod();
        }
        catch (NoSuchMethodException e) {
            System.out.println(c.getInternalException() + " in " + visitor.getClass().getName() + ".visit(" + this.getClass().getName() + ")");
            c.getInternalException().printStackTrace();
        }
        return returnValue;
    }

    public void addParameterUpdateListener(ParameterUpdateListener l) {
        if (!this.getParameterUpdateListeners().contains(l)) {
            this.getParameterUpdateListeners().addElement(l);
        }
    }

    protected boolean calculateValue(double input1) {
        System.out.println("BlockParameter.calculateValue(double)");
        System.out.println("*** Warning: Ausgangswert der Sonderfunktion: " + this.getClass().getName() + " nicht berechnet!");
        return false;
    }

    protected boolean calculateValue(double param1, double param2) {
        System.out.println("*** Warning: Sonderfunktion: " + this.getClass().getName() + " hat kein calulateValue(double,double)!");
        return false;
    }

    protected boolean calculateValue(int input1) {
        System.out.println("BlockParameter.calculateValue(int)");
        System.out.println("*** Warning: Sonderfunktion: " + this.getClass().getName() + " hat kein calculateValue(int)!");
        return false;
    }

    protected boolean calculateValue(int input1, int input2) {
        System.out.println("*** Warning: Sonderfunktion: " + this.getClass().getName() + " hat kein calculateValue(int,int)!");
        return false;
    }

    protected boolean calculateValue(boolean input1) {
        System.out.println("*** Warning: Sonderfunktion: " + this.getClass().getName() + " hat kein calculateValue(boolean)!");
        return false;
    }

    protected boolean calculateValue(boolean param1, boolean param2) {
        System.out.println("*** Warning: Sonderfunktion: " + this.getClass().getName() + " hat kein calulateValue(boolean,boolean)!");
        return false;
    }

    public void fireParameterSetEvent() {
        super.fireParameterSetEvent();
        this.getBlock().getWiringDiagram().setModified(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireParameterUpdateEvent() {
        if (!this.getParameterUpdateListeners().isEmpty()) {
            Vector l;
            ParameterUpdateEvent pue = this.getParameterUpdateEvent();
            BlockParameter blockParameter = this;
            synchronized (blockParameter) {
                l = (Vector)this.fParameterUpdateListeners.clone();
            }
            for (int i = 0; i < l.size(); ++i) {
                ParameterUpdateListener pul = (ParameterUpdateListener)l.elementAt(i);
                pul.parameterUpdated(pue);
            }
        }
    }

    public int getAllocatedParameter() {
        return this.fParameter;
    }

    public int getAllocatedRAM() {
        if (!this.getRemanenceAvailable() || !this.getRemanenceObject().getRemanence()) {
            return this.fData;
        }
        return 0;
    }

    public int getAllocatedREM() {
        if (this.getRemanenceAvailable() && this.getRemanenceObject().getRemanence()) {
            return this.fData;
        }
        return 0;
    }

    public int getAllocatedTimer() {
        return this.fAllocatedTimer;
    }

    public Block getBlock() {
        return this.fBlock;
    }

    protected String calculateCurrentParameterText() {
        return "";
    }

    public String getLocalizedName(boolean withBlockNumber) {
        return this.getBlock().getLocalizedName(true);
    }

    public String getCurrentParameterText() {
        if (this.fCurrentParameterText == null) {
            this.fCurrentParameterText = "";
        }
        return this.fCurrentParameterText;
    }

    public String getParameterText() {
        if (!this.getRemanenceAvailable()) {
            return "";
        }
        return this.getRemanenceObject().getParameterText();
    }

    public ParameterUpdateEvent getParameterUpdateEvent() {
        if (this.fParameterUpdateEvent == null) {
            this.fParameterUpdateEvent = new ParameterUpdateEvent(this);
        }
        return this.fParameterUpdateEvent;
    }

    protected Vector getParameterUpdateListeners() {
        if (this.fParameterUpdateListeners == null) {
            this.fParameterUpdateListeners = new Vector();
        }
        return this.fParameterUpdateListeners;
    }

    public boolean getRemanenceAvailable() {
        return this.fRemanence != null;
    }

    public Remanence getRemanenceObject() {
        return this.fRemanence;
    }

    public void setRemanenceObject(Remanence remanceObject) {
        this.fRemanence = remanceObject;
    }

    public boolean getValue() {
        return false;
    }

    public boolean getValue(double input1) {
        boolean result = this.calculateValue(input1);
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return result;
    }

    public boolean getValue(double input1, double input2) {
        boolean result = this.calculateValue(input1, input2);
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return result;
    }

    public boolean getValue(int input1, int input2) {
        boolean result = this.calculateValue(input1, input2);
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return result;
    }

    public boolean getValue(boolean input1) {
        boolean result = this.calculateValue(input1);
        this.getParameterUpdateEvent().setBinaryValue(result);
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return result;
    }

    public boolean getValue(boolean input1, boolean input2) {
        boolean result = this.calculateValue(input1, input2);
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return result;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        this.fInterpreter = interpreter;
        this.fCurrentParameterText = "";
        this.fLastBinaryValue = false;
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.fBlock = (Block)dr.readStorable();
        this.fData = dr.readInt();
        this.fAllocatedTimer = dr.readInt();
        this.fParameter = dr.readInt();
        this.fRemanence = (Remanence)dr.readStorable();
        if (this.fRemanence != null) {
            this.fRemanence.setParameter(this);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.fRemanence != null) {
            this.fRemanence.setParameter(this);
        }
    }

    public void removeAllListener() {
        this.fParameterSetListeners = null;
        this.fParameterUpdateListeners = null;
    }

    public void removeParameterUpdateListener(ParameterUpdateListener l) {
        this.getParameterUpdateListeners().removeElement(l);
    }

    public void setBlockNumberString(String newNumber) {
        try {
            this.getBlock().setNumberString(newNumber);
            if (this.getBlock().getWiringDiagram() != null) {
                this.getBlock().getWiringDiagram().getMessageManager().verifyMessageLineParameterReferences();
            }
        }
        catch (IllegalArgumentException e) {
            return;
        }
    }

    protected void setParameterNameKeys() {
    }

    public void setParameterUpdateEvent(ParameterUpdateEvent newFParameterUpdateEvent) {
        this.fParameterUpdateEvent = newFParameterUpdateEvent;
    }

    public void setRemanenceAvailable(boolean state) {
        if (!state) {
            this.fRemanence = null;
        } else if (this.fRemanence == null) {
            this.fRemanence = new Remanence();
            this.fRemanence.setParameter(this);
        }
    }

    public String toString() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46));
        this.calculateCurrentParameterText();
        return new StringBuffer(className).append("-").append(this.getBlock().getNumberString()).append("\n").append(this.getParameterText()).toString();
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(this.fBlock);
        dw.writeInt(this.fData);
        dw.writeInt(this.fAllocatedTimer);
        dw.writeInt(this.fParameter);
        dw.writeStorable(this.fRemanence);
    }

    public boolean compareTo(BlockParameter other, DifferenceTableModel differences) {
        Object[] o;
        String[] str;
        String otherString;
        String thisString;
        if (other == null) {
            return false;
        }
        boolean result = true;
        String blockID = this.getBlock().getNumberString() + " - ";
        if (this.getBlock().getClass() != other.getBlock().getClass()) {
            return false;
        }
        ParameterItemValueComparator comparator = ParameterItemValueComparator.getInstance();
        ParameterItemValueFormatter formatter = ParameterItemValueFormatter.getInstance();
        ParameterItemList thisItemList = this.getParameterItems().getParameterItemListOfType(0).instance(this);
        ParameterItemList otherItemList = other.getParameterItems().getParameterItemListOfType(0).instance(other);
        ArrayList resultList = new ArrayList(4);
        Util.getDifferences(thisItemList, otherItemList, resultList);
        List onlyInThisList = (List)resultList.get(0);
        List onlyInOtherList = (List)resultList.get(1);
        List itemsInBothListsThis = (List)resultList.get(2);
        List itemsInBothListsOther = (List)resultList.get(3);
        Iterator iteratorThis = itemsInBothListsThis.iterator();
        Iterator iteratorOther = itemsInBothListsOther.iterator();
        while (iteratorThis.hasNext()) {
            ParameterItem thisItem = (ParameterItem)iteratorThis.next();
            ParameterItem otherItem = (ParameterItem)iteratorOther.next();
            thisString = formatter.formatLogo(thisItem, thisItem.getValue());
            otherString = formatter.formatLogo(otherItem, otherItem.getValue());
            if (comparator.compare(thisItem, otherItem)) continue;
            if (thisItem.getValue() instanceof MessageParameter.MessageText && ParameterItemValueComparator.firstDifference[0] != null) {
                thisString = ParameterItemValueComparator.firstDifference[0];
                otherString = ParameterItemValueComparator.firstDifference[1];
            }
            str = new String[]{blockID + thisItem.getLocalisedName(), thisString, otherString};
            o = new Object[]{this.getBlock(), other.getBlock()};
            differences.add(str, o);
        }
        for (ParameterItem thisItem : onlyInThisList) {
            thisString = formatter.formatLogo(thisItem, thisItem.getValue());
            otherString = "Parameter not available";
            str = new String[]{blockID + thisItem.getLocalisedName(), thisString, otherString};
            o = new Object[]{this.getBlock(), other.getBlock()};
            differences.add(str, o);
        }
        for (ParameterItem otherItem : onlyInOtherList) {
            thisString = "Parameter not available";
            otherString = formatter.formatLogo(otherItem, otherItem.getValue());
            str = new String[]{blockID + otherItem.getLocalisedName(), thisString, otherString};
            o = new Object[]{this.getBlock(), other.getBlock()};
            differences.add(str, o);
        }
        if (this instanceof ProtectionParameter && ((ProtectionParameter)this).getProtection() != ((ProtectionParameter)other).getProtection()) {
            String[] str2 = new String[]{blockID + Language.getString("compare.protection", "Protection"), ((ProtectionParameter)this).getProtectionSign(), ((ProtectionParameter)other).getProtectionSign()};
            Object[] o2 = new Object[]{this.getBlock(), other.getBlock()};
            differences.add(str2, o2);
        }
        result = false;
        return result;
    }

    public ParameterItemList getParameterItems() {
        ParameterItemList parameterItemList = null;
        Hardware hw = this.getBlock().getHardware();
        if (hw != null) {
            ParameterItemTable exportedParameters = (ParameterItemTable)hw.getProperty("parameterItemTable");
            parameterItemList = exportedParameters.getParameterItems(this);
        }
        if (parameterItemList == null) {
            parameterItemList = new ParameterItemList(null, 0);
        }
        return parameterItemList;
    }

    public ParameterItem getParameterItem(String parameterItemIdentifier) {
        ParameterItem abstractParameterItem = this.getParameterItems().getParameterItem(parameterItemIdentifier);
        if (abstractParameterItem == null) {
            return null;
        }
        return abstractParameterItem.getInstanceForParameter(this);
    }

    public ParameterItem getParameterItem(int parameterNumber) {
        ParameterItem abstractParameterItem = this.getParameterItems().getParameterItem(parameterNumber);
        if (abstractParameterItem == null) {
            return null;
        }
        return abstractParameterItem.getInstanceForParameter(this);
    }

    public boolean isAvailable(Hardware hardware, List errorList) {
        Iterator sourceList = this.getParameterItems().getValueOrReferenceItems().iterator();
        while (sourceList.hasNext()) {
            ParameterItem item = ((ParameterItem)sourceList.next()).getInstanceForParameter(this);
            ValueOrItemReference value = (ValueOrItemReference)item.getValue();
            if (!value.isReference()) continue;
            if (!hardware.supports("referenceFunction")) {
                errorList.add(new ErrorInfo(this, "error.convert.blockParameter.referenceToParameterNotSupported", hardware));
                return false;
            }
            if (value.getReference().getValue() instanceof TimeUnit && !hardware.supports("TimeValueAsReferenceSource")) {
                errorList.add(new ErrorInfo(this, "error.convert.blockParameter.referenceToTimeValueNotSupported", hardware));
                return false;
            }
            if (!value.getReference().getParameter().getBlock().getName().equalsIgnoreCase("Trigger") || hardware.supports("supportTriggerAsParamSRC")) continue;
            errorList.add(new ErrorInfo(this, "error.hardware.referenceSRCNotSupported", hardware));
            return false;
        }
        return true;
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        Iterator itemList = this.getParameterItems().getValueOrReferenceItems().iterator();
        while (itemList.hasNext()) {
            ParameterItem item = ((ParameterItem)itemList.next()).getInstanceForParameter(this);
            ((ValueOrItemReference)item.getValue()).hardwareChanged(hardwareChangedEvent);
        }
    }

    public boolean isValueOrReference() {
        ParameterItemList paramList = this.getParameterItems().getValueOrReferenceItems();
        return paramList.size() > 0;
    }

    public void setCurrentParameterText(String currentParameterText) {
        this.fCurrentParameterText = currentParameterText;
        this.fireParameterUpdateEvent();
    }

    public boolean hasReferenceToParameterItem() {
        return !this.getParameterItems().getItemsWithReference(this).isEmpty();
    }

    public void deleteReferencesToParameterItem(HashMap resultDict) {
        Iterator itemList = this.getParameterItems().getItemsWithReference(this).iterator();
        if (itemList.hasNext()) {
            ArrayList<Block> propChanged = (ArrayList<Block>)resultDict.get("propChanged");
            ArrayList<String> propChangedStr = (ArrayList<String>)resultDict.get("propChangedString");
            if (propChanged == null) {
                propChanged = new ArrayList<Block>();
                propChangedStr = new ArrayList<String>();
                resultDict.put("propChanged", propChanged);
                resultDict.put("propChangedString", propChangedStr);
            }
            do {
                ParameterItem item = (ParameterItem)itemList.next();
                ValueOrItemReference value = (ValueOrItemReference)item.getValue();
                item.setValue(value.setDefaultDirectValue());
                propChanged.add(item.getParameter().getBlock());
                propChangedStr.add(Language.getString("msg.referenceDeleted", "Reference deleted (%)", item));
            } while (itemList.hasNext());
        }
    }

    public boolean supportsUserDefinedName() {
        return this.getBlock().supportsUserDefinedName();
    }

    public Interpreter getInterpreter() {
        return this.fInterpreter;
    }
}

